package gov.va.med.mhv.mrp.enums;

public enum GoalPriorityTypeEnumeration {
	IMPORTANT(1, "Goals Most Important to Me"), SECOND_IMPORTANT(2, "Goals Second Most Important to Me"), OTHER(3,
			"My Other Goals");

	private Integer code;
	private String description;

	private GoalPriorityTypeEnumeration(Integer code, String description) {
		this.code = code;
		this.description = description;
	}

	public static GoalPriorityTypeEnumeration findByCode(Integer code) {
		for (GoalPriorityTypeEnumeration e : GoalPriorityTypeEnumeration.values()) {
			if (e.code == code) {
				return e;
			}
		}
		// could be bad data, so just put it in the "My Other Goals" category
		return GoalPriorityTypeEnumeration.OTHER;
	}
	
	public Integer getCode() {
		return code;
	}

	public String getDescription() {
		return description;
	}

}
